<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Location Tracker</title>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
</head>
<body>
    <div id="container">
        <h1>Location Tracker</h1>
        <button id="trackBtn">Track My Location</button>
    </div>

    <script>
        $(document).ready(function() {
            $('#trackBtn').click(function() {
                if (navigator.geolocation) {
                    navigator.geolocation.getCurrentPosition(successCallback, errorCallback);
                } else {
                    alert("Geolocation is not supported by this browser.");
                }
            });

            function successCallback(position) {
                var latitude = position.coords.latitude;
                var longitude = position.coords.longitude;
                var accuracy = position.coords.accuracy;

                $.post("", { latitude: latitude, longitude: longitude, accuracy: accuracy })
                    .done(function(response) {
                        alert(response); // Alert the response from PHP (e.g., success message)
                    })
                    .fail(function(error) {
                        alert("Failed to store location: " + error.statusText);
                    });
            }

            function errorCallback(error) {
                switch(error.code) {
                    case error.PERMISSION_DENIED:
                        alert("User denied the request for Geolocation.");
                        break;
                    case error.POSITION_UNAVAILABLE:
                        alert("Location information is unavailable.");
                        break;
                    case error.TIMEOUT:
                        alert("The request to get user location timed out.");
                        break;
                    case error.UNKNOWN_ERROR:
                        alert("An unknown error occurred.");
                        break;
                }
            }
        });
    </script>

    <?php
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $latitude = $_POST['latitude'];
        $longitude = $_POST['longitude'];
        $accuracy = $_POST['accuracy'];

        // Example: Store location data in a text file
        $data = "Latitude: $latitude, Longitude: $longitude, Accuracy: $accuracy\n";
        $file = 'locations.txt';
        file_put_contents($file, $data, FILE_APPEND);

        echo "Location stored successfully!";
    }
    ?>
</body>
</html>
